<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Banner Manager</title>
    <style>
        /* Style for layout similar to Netflix */
        .banner-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .banner-container img {
            width: 200px;
            height: 100px;
            object-fit: cover;
            margin: 10px;
            border-radius: 5px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.3);
            transition: transform 0.3s ease;
        }

        .banner-container img:hover {
            transform: scale(1.05);
        }

        .horizontal-line {
            border-top: 1px solid #ccc;
            margin-bottom: 20px;
        }

        /* Style for the edit button */
        .editar-button {
            background-color: transparent;
            color: #fff;
            border: 2px solid #fff;
            padding: 5px 10px;
            border-radius: 5px;
            cursor: pointer;
            margin-right: 5px;
            transition: background-color 0.3s ease;
        }

        .editar-button:hover {
            background-color: rgba(255, 255, 255, 0.3);
        }

        /* Style for the upload area when the edit form is displayed */
        .editar-form {
            display: none;
            margin-top: 10px;
        }

        .editar-form input[type="file"] {
            display: block;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <?php include('includes/header.php'); ?>    
    <div class="col-md-12 mx-auto ctmain-table">
        <div class="card-body">
            <div class="card ctcard">
                <div class="card-header card-header-warning">
                    <center>
                        <h2><i class="icon icon-commenting"></i> Add or Edit Banners</h2>
                    </center>
                </div>
                <div class="card-body">
                    <div class="col-12">
                        <form action="process_banner.php" method="post" enctype="multipart/form-data">
                            <input type="file" name="banner" accept="image/*" required>
                            <button class="editar-button" type="submit" name="submit">Add Banner</button>
                        </form>

                        <h2>Existing Banners</h2>
                        <div class="banner-container">
                            <?php
$directory = 'banners/';
$banners = glob($directory . '*.{jpg,jpeg,png,gif}', GLOB_BRACE);
foreach ($banners as $banner) {
    echo "<div>";
    echo "<img src='$banner' alt='Banner'>";
    echo "<form action='process_banner.php' method='post'>";
    echo "<input type='hidden' name='old_banner' value='" . urlencode(basename($banner)) . "'>";
    echo "<button class='editar-button' type='submit' name='delete'>Delete</button>";
    echo "</form>";
    echo "<button class='editar-button' onclick='showEditForm(this)'>Edit</button>";
    echo "<form class='editar-form' action='process_banner.php' method='post' enctype='multipart/form-data'>";
    echo "<input type='hidden' name='old_banner' value='" . urlencode(basename($banner)) . "'>";
    echo "<input type='file' name='new_banner' accept='image/*' required title='Upload Image'>";
    echo "<button type='submit' name='edit'>Save</button>";
    echo "</form>";
    echo "</div>";
}
?>


                        </div>
                        <div class="horizontal-line"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include('includes/footer.php'); ?>
    <script>
        function showEditForm(button) {
            var editForm = button.nextElementSibling;
            editForm.classList.toggle('editar-form');
        }
    </script>
</body>
</html>
